/*
 * Decompiled with CFR 0.152.
 */
package mqjfx.mq;

import com.ibm.mq.MQDestination;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQTopic;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.MQHeaderList;
import com.ibm.mq.headers.MQMD;
import java.io.DataInput;
import java.io.IOException;
import java.util.Hashtable;
import mqjfx.debug.debugMessage;
import mqjfx.mq.MQGMOFields;
import mqjfx.mq.MQMDParam;
import mqjfx.mq.MQOptions;

public class MQBJ {
    String QueueManager;
    String Queue;
    String topicString;
    String topicObject;
    String ObjectQueueManager;
    String message;
    MQQueueManager qMgr;

    public MQBJ(String QueueManager, String Queue, String ObjectQueueManager, String message) {
        debugMessage.printDebugMessageStdout("start: MQBJ.MQBJ");
        MQEnvironment.properties.remove("hostname");
        MQEnvironment.properties.remove("channel");
        MQEnvironment.properties.remove("port");
        MQEnvironment.properties.remove("transport");
        MQEnvironment.properties.remove("userID");
        this.QueueManager = QueueManager;
        this.Queue = Queue;
        this.ObjectQueueManager = ObjectQueueManager;
        this.message = message;
        debugMessage.printDebugMessageStdout("stop: MQBJ.MQBJ");
    }

    public MQBJ(String QueueManager, String Queue, String ObjectQueueManager, String message, String HostName, String Channel2, String Port, String UserId) {
        debugMessage.printDebugMessageStdout("start: MQBJ.MQBJ");
        this.QueueManager = QueueManager;
        this.Queue = Queue;
        this.ObjectQueueManager = ObjectQueueManager;
        this.message = message;
        MQEnvironment.properties.put("hostname", HostName);
        MQEnvironment.properties.put("channel", Channel2);
        MQEnvironment.properties.put("port", new Integer(Integer.valueOf(Port)));
        MQEnvironment.properties.put("transport", "MQSeries Client");
        MQEnvironment.properties.put("userID", UserId);
        debugMessage.printDebugMessageStdout("stop: MQBJ.MQBJ");
    }

    public MQBJ(String QueueManager, String topicString, String topicObject, String ObjectQueueManager, String message) {
        debugMessage.printDebugMessageStdout("start: MQBJ.MQBJ");
        MQEnvironment.properties.remove("hostname");
        MQEnvironment.properties.remove("channel");
        MQEnvironment.properties.remove("port");
        MQEnvironment.properties.remove("transport");
        MQEnvironment.properties.remove("userID");
        this.QueueManager = QueueManager;
        this.topicString = topicString;
        this.topicObject = topicObject;
        this.ObjectQueueManager = ObjectQueueManager;
        this.message = message;
        debugMessage.printDebugMessageStdout("stop: MQBJ.MQBJ");
    }

    public MQBJ(String QueueManager, String topicString, String topicObject, String ObjectQueueManager, String message, String HostName, String Channel2, String Port, String UserId) {
        debugMessage.printDebugMessageStdout("start: MQBJ.MQBJ");
        MQEnvironment.properties.put("hostname", HostName);
        MQEnvironment.properties.put("channel", Channel2);
        MQEnvironment.properties.put("port", new Integer(Integer.valueOf(Port)));
        MQEnvironment.properties.put("transport", "MQSeries Client");
        MQEnvironment.properties.put("userID", UserId);
        this.QueueManager = QueueManager;
        this.topicString = topicString;
        this.topicObject = topicObject;
        this.ObjectQueueManager = ObjectQueueManager;
        this.message = message;
        debugMessage.printDebugMessageStdout("stop: MQBJ.MQBJ");
    }

    void setMQMD(MQMessage msg, MQMDParam mqmdParam) throws MQException {
        debugMessage.printDebugMessageStdout("start: MQBJ.setMQMD");
        if (mqmdParam.Versionflag) {
            msg.setVersion(mqmdParam.getVersion().intValue());
        }
        if (mqmdParam.Reportflag) {
            msg.report = mqmdParam.getReport();
        }
        if (mqmdParam.MsgTypeflag) {
            msg.messageType = mqmdParam.getMsgType();
        }
        if (mqmdParam.Expiryflag) {
            msg.expiry = mqmdParam.getExpiry();
        }
        if (mqmdParam.Feedbackflag) {
            msg.feedback = mqmdParam.getFeedback();
        }
        if (mqmdParam.Encodingflag) {
            msg.encoding = mqmdParam.getEncoding();
        }
        if (mqmdParam.CodedCharSetIdflag) {
            msg.characterSet = mqmdParam.getCodedCharSetId();
        }
        if (mqmdParam.Formatflag) {
            msg.format = mqmdParam.getFormat();
        }
        if (mqmdParam.Priorityflag) {
            msg.priority = mqmdParam.getPriority();
        }
        if (mqmdParam.Persistenceflag) {
            msg.persistence = mqmdParam.getPersistence();
        }
        if (mqmdParam.MsgIdflag) {
            msg.messageId = mqmdParam.getMsgId();
        }
        if (mqmdParam.CorrelIdflag) {
            msg.correlationId = mqmdParam.getCorrelId();
        }
        if (mqmdParam.ReplyToQflag) {
            msg.replyToQueueName = mqmdParam.getReplyToQ();
        }
        if (mqmdParam.ReplyToQMgrflag) {
            msg.replyToQueueManagerName = mqmdParam.getReplyToQMgr();
        }
        if (mqmdParam.UserIdentifierflag) {
            msg.userId = mqmdParam.getUserIdentifier();
        }
        if (mqmdParam.AccountingTokenflag) {
            msg.accountingToken = mqmdParam.getAccountingToken();
        }
        if (mqmdParam.ApplIdentityDataflag) {
            msg.applicationIdData = mqmdParam.getApplIdentityData();
        }
        if (mqmdParam.PutApplTypeflag) {
            msg.putApplicationType = mqmdParam.getPutApplType();
        }
        if (mqmdParam.PutApplNameflag) {
            msg.putApplicationName = mqmdParam.getPutApplName();
        }
        if (mqmdParam.PutDateTimeflag) {
            msg.putDateTime = mqmdParam.getPutDateTime();
        }
        if (mqmdParam.ApplOriginDataflag) {
            msg.applicationOriginData = mqmdParam.getApplOriginData();
        }
        if (mqmdParam.GroupIdflag) {
            msg.groupId = mqmdParam.getGroupId();
        }
        if (mqmdParam.MsgSeqNumberflag) {
            msg.messageSequenceNumber = mqmdParam.getMsgSeqNumber();
        }
        if (mqmdParam.Offsetflag) {
            msg.offset = mqmdParam.getOffset();
        }
        if (mqmdParam.MsgFlagsflag) {
            msg.messageFlags = mqmdParam.getMsgFlags();
        }
        if (mqmdParam.OriginalLengthflag) {
            msg.originalLength = mqmdParam.getOriginalLength();
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.setMQMD");
    }

    String put(MQMDParam mqmdParam, MQOptions mqOptions) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.put");
        String returnMsg = null;
        try {
            System.out.println("Connecting to queue manager: " + this.QueueManager);
            this.qMgr = new MQQueueManager(this.QueueManager);
            int openOptions = 16;
            System.out.println("Accessing queue: " + this.Queue);
            if (mqOptions.MQOO_openOptionsflag) {
                openOptions |= mqOptions.getMQOO_openOptions().intValue();
            }
            System.out.println("ObjectQueueManager" + this.ObjectQueueManager);
            MQQueue queue = this.qMgr.accessQueue(this.Queue, openOptions, this.ObjectQueueManager, "", "");
            MQMessage msg = new MQMessage();
            msg.writeString(this.message);
            this.setMQMD(msg, mqmdParam);
            MQPutMessageOptions pmo = new MQPutMessageOptions();
            if (mqOptions.MQPMO_Optionsflag) {
                pmo.options = mqOptions.getMQPMO_Options();
            }
            System.out.println("Sending a message...");
            queue.put(msg, pmo);
            System.out.println("Closing the queue");
            queue.close();
            System.out.println("Disconnecting from the Queue Manager");
            this.qMgr.disconnect();
            this.qMgr = null;
            System.out.println("Done!");
            MQMD md = new MQMD();
            md.copyFrom((com.ibm.mq.MQMD)msg);
            returnMsg = "Send message:\n" + md + "\n" + new MQHeaderList((DataInput)msg, true) + this.message + "\n";
            System.out.println("SUCCESS");
            returnMsg = returnMsg + "SUCCESS\n";
            System.out.println(returnMsg);
        }
        catch (IOException ex) {
            System.out.println("An IOException occured whilst writing to the message buffer: " + ex);
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.put");
        return returnMsg;
    }

    String get(MQMDParam mqmdParam, MQOptions mqOptions) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.get");
        String returnMsg = null;
        try {
            System.out.println("Connecting to queue manager: " + this.QueueManager);
            this.qMgr = new MQQueueManager(this.QueueManager);
            int openOptions = 0;
            System.out.println("Accessing queue: " + this.Queue);
            if (!mqOptions.MQOO_openOptionsflag || (mqOptions.getMQOO_openOptions() & 7) == 0) {
                openOptions = 1;
            }
            if (mqOptions.MQOO_openOptionsflag) {
                openOptions |= mqOptions.getMQOO_openOptions().intValue();
            }
            System.out.println("openOptions: " + openOptions);
            MQQueue queue = this.qMgr.accessQueue(this.Queue, openOptions);
            MQMessage rcvMessage = new MQMessage();
            this.setMQMD(rcvMessage, mqmdParam);
            MQGetMessageOptions gmo = new MQGetMessageOptions();
            if (mqOptions.MQGMO_Optionsflag) {
                gmo.options = mqOptions.getMQGMO_Options();
            }
            System.out.println("gmo.options: " + gmo.options);
            if (mqOptions.MQGMO_matchOptionsflag) {
                gmo.matchOptions = mqOptions.getMQGMO_matchOptions();
            }
            System.out.println("...and getting the message back again");
            queue.get(rcvMessage, gmo);
            String msgText = rcvMessage.readStringOfCharLength(rcvMessage.getDataLength());
            System.out.println("The message is: " + msgText);
            System.out.println("Closing the queue");
            queue.close();
            System.out.println("Disconnecting from the Queue Manager");
            this.qMgr.disconnect();
            this.qMgr = null;
            System.out.println("Done!");
            MQMD md = new MQMD();
            md.copyFrom((com.ibm.mq.MQMD)rcvMessage);
            returnMsg = "Receive message:\n" + md + "\n" + new MQHeaderList((DataInput)rcvMessage, true) + msgText + "\n";
            System.out.println("SUCCESS");
            returnMsg = returnMsg + "SUCCESS\n";
            System.out.println(returnMsg);
        }
        catch (IOException ex) {
            System.out.println("An IOException occured whilst writing to the message buffer: " + ex);
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.get");
        return returnMsg;
    }

    String put_get(MQMDParam mqmdParamforPut, MQOptions mqOptionsforPut, MQMDParam mqmdParamforGet, MQOptions mqOptionsforGet, String DynamicQname) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.put_get");
        String returnMsg = null;
        try {
            System.out.println("Connecting to queue manager: " + this.QueueManager);
            this.qMgr = new MQQueueManager(this.QueueManager);
            int openOptionsforPut = 16;
            System.out.println("Accessing queue: " + this.Queue);
            if (mqOptionsforPut.MQOO_openOptionsflag) {
                openOptionsforPut |= mqOptionsforPut.getMQOO_openOptions().intValue();
            }
            System.out.println("ObjectQueueManager" + this.ObjectQueueManager);
            MQQueue queueforPut = this.qMgr.accessQueue(this.Queue, openOptionsforPut, this.ObjectQueueManager, "", "");
            MQMessage msg = new MQMessage();
            msg.writeString(this.message);
            this.setMQMD(msg, mqmdParamforPut);
            MQPutMessageOptions pmo = new MQPutMessageOptions();
            if (mqOptionsforPut.MQPMO_Optionsflag) {
                pmo.options = mqOptionsforPut.getMQPMO_Options();
            }
            System.out.println("Sending a message...");
            queueforPut.put(msg, pmo);
            System.out.println("Closing the queue");
            queueforPut.close();
            System.out.println("Disconnecting from the Queue Manager");
            this.qMgr.disconnect();
            this.qMgr = null;
            System.out.println("Done!");
            MQMD mdforPut = new MQMD();
            mdforPut.copyFrom((com.ibm.mq.MQMD)msg);
            returnMsg = "Send message:\n" + mdforPut + "\n" + new MQHeaderList((DataInput)msg, true) + this.message + "\n";
            System.out.println("SUCCESS");
            returnMsg = returnMsg + "SUCCESS\n";
            System.out.println(returnMsg);
            int openOptionsforGet = 0;
            System.out.println("Accessing queue: " + this.Queue);
            if (!mqOptionsforGet.MQOO_openOptionsflag || (mqOptionsforGet.getMQOO_openOptions() & 7) == 0) {
                openOptionsforGet = 1;
            }
            if (mqOptionsforGet.MQOO_openOptionsflag) {
                openOptionsforGet |= mqOptionsforGet.getMQOO_openOptions().intValue();
            }
            System.out.println("openOptionsforGet: " + openOptionsforGet);
            MQQueue queueforGet = this.qMgr.accessQueue(DynamicQname, openOptionsforGet);
            MQMessage rcvMessage = new MQMessage();
            this.setMQMD(rcvMessage, mqmdParamforGet);
            MQGetMessageOptions gmo = new MQGetMessageOptions();
            if (mqOptionsforGet.MQGMO_Optionsflag) {
                gmo.options = mqOptionsforGet.getMQGMO_Options();
            }
            System.out.println("gmo.options: " + gmo.options);
            if (mqOptionsforGet.MQGMO_matchOptionsflag) {
                gmo.matchOptions = mqOptionsforGet.getMQGMO_matchOptions();
            }
            System.out.println("...and getting the message back again");
            queueforGet.get(rcvMessage, gmo);
            String msgText = rcvMessage.readStringOfCharLength(rcvMessage.getDataLength());
            System.out.println("The message is: " + msgText);
            System.out.println("Closing the queue");
            queueforGet.close();
            MQMD mdforGet = new MQMD();
            mdforGet.copyFrom((com.ibm.mq.MQMD)rcvMessage);
            returnMsg = "Receive message:\n" + mdforGet + "\n" + new MQHeaderList((DataInput)rcvMessage, true) + msgText + "\n";
            System.out.println("SUCCESS");
            returnMsg = returnMsg + "SUCCESS\n";
            System.out.println(returnMsg);
            System.out.println("Disconnecting from the Queue Manager");
            this.qMgr.disconnect();
            this.qMgr = null;
            System.out.println("Done!");
        }
        catch (IOException ex) {
            System.out.println("An IOException occured whilst writing to the message buffer: " + ex);
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.put_get");
        return returnMsg;
    }

    public MQQueueManager mqConnect() throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqConnect");
        try {
            System.out.println("Connecting to queue manager: " + this.QueueManager);
            this.qMgr = new MQQueueManager(this.QueueManager);
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.mqConnect");
        return this.qMgr;
    }

    public MQQueueManager mqConnect(String MQuserId, String MQpassword) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqConnect");
        try {
            System.out.println("Connecting to queue manager: " + this.QueueManager + " with userId: " + MQuserId + " password: " + MQpassword);
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            h.put("userID", MQuserId);
            h.put("password", MQpassword);
            h.put("Use MQCSP authentication", true);
            this.qMgr = new MQQueueManager(this.QueueManager, h);
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.mqConnect");
        return this.qMgr;
    }

    public MQQueueManager mqConnect(int options) throws MQException, MQDataException {
        try {
            System.out.println("Connecting to queue manager: " + this.QueueManager);
            this.qMgr = new MQQueueManager(this.QueueManager, options);
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
        return this.qMgr;
    }

    public MQQueueManager mqConnect(String hostname, String port, String channel, String userid) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqConnect");
        try {
            System.out.println("Connecting to queue manager: " + this.QueueManager + " with hostname: " + hostname + " port: " + port + " channel: " + channel);
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            properties.put("hostname", hostname);
            if (port != null && port.length() != 0) {
                properties.put("port", new Integer(Integer.parseInt(port)));
            }
            properties.put("channel", channel);
            properties.put("transport", "MQSeries Client");
            properties.put("userID", userid);
            this.qMgr = new MQQueueManager(this.QueueManager, properties);
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.mqConnect");
        return this.qMgr;
    }

    public void mqDisconnect() throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqDisconnect");
        try {
            System.out.println("Disconnecting from the Queue Manager");
            this.qMgr.disconnect();
            this.qMgr = null;
            System.out.println("Done!");
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr = null;
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.mqDisconnect");
    }

    public MQQueue mqOpenforPut(MQOptions mqOptions) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqOpenforPut");
        try {
            int openOptions = 16;
            System.out.println("Accessing queue: " + this.Queue);
            if (mqOptions.MQOO_openOptionsflag) {
                openOptions |= mqOptions.getMQOO_openOptions().intValue();
            }
            System.out.println("ObjectQueueManager" + this.ObjectQueueManager);
            MQQueue queue = this.qMgr.accessQueue(this.Queue, openOptions, this.ObjectQueueManager, "", "");
            debugMessage.printDebugMessageStdout("stop: MQBJ.mqOpenforPut");
            return queue;
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
    }

    public MQQueue mqOpenforGet(MQOptions mqOptions, String ModelQname, String DynamicQname) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqOpenforGet");
        try {
            int openOptions = 0;
            System.out.println("Accessing queue: " + ModelQname);
            if (!mqOptions.MQOO_openOptionsflag || (mqOptions.getMQOO_openOptions() & 7) == 0) {
                openOptions = 1;
            }
            if (mqOptions.MQOO_openOptionsflag) {
                openOptions |= mqOptions.getMQOO_openOptions().intValue();
            }
            System.out.println("openOptionsforGet: " + openOptions);
            MQQueue queue = this.qMgr.accessQueue(ModelQname, openOptions, this.QueueManager, DynamicQname, "");
            debugMessage.printDebugMessageStdout("stop: MQBJ.mqOpenforGet");
            return queue;
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
    }

    public void mqClose(MQQueue queue) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqClose");
        try {
            System.out.println("Closing the queue");
            queue.close();
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr = null;
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.mqClose");
    }

    public String mqPut(MQQueue queue, MQMDParam mqmdParam, MQOptions mqOptions, String putMessage) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqPut");
        String returnMsg = null;
        try {
            MQMessage msg = new MQMessage();
            msg.writeString(putMessage);
            this.setMQMD(msg, mqmdParam);
            MQPutMessageOptions pmo = new MQPutMessageOptions();
            if (mqOptions.MQPMO_Optionsflag) {
                pmo.options = mqOptions.getMQPMO_Options();
            }
            System.out.println("Sending a message...");
            queue.put(msg, pmo);
            MQMD md = new MQMD();
            md.copyFrom((com.ibm.mq.MQMD)msg);
            returnMsg = "Send message:\n" + md + "\n" + new MQHeaderList((DataInput)msg, true) + putMessage + "\n";
            System.out.println("SUCCESS");
            returnMsg = returnMsg + "SUCCESS\n";
            System.out.println(returnMsg);
        }
        catch (IOException ex) {
            System.out.println("An IOException occured whilst writing to the message buffer: " + ex);
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.mqPut");
        return returnMsg;
    }

    public String[] mqGet(MQQueue queue, MQMDParam mqmdParam, MQOptions mqOptions, MQGMOFields mqgmoFields) throws MQException, MQDataException, IOException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqGet");
        String[] returnMsg = new String[2];
        try {
            MQMessage rcvMessage = new MQMessage();
            this.setMQMD(rcvMessage, mqmdParam);
            MQGetMessageOptions gmo = new MQGetMessageOptions();
            if (mqOptions.MQGMO_Optionsflag) {
                gmo.options = mqOptions.getMQGMO_Options();
            }
            System.out.println("gmo.options: " + gmo.options);
            gmo.waitInterval = mqgmoFields.getWaitInterval();
            if (mqOptions.MQGMO_matchOptionsflag) {
                gmo.matchOptions = mqOptions.getMQGMO_matchOptions();
            }
            System.out.println("...and getting the message back again");
            queue.get(rcvMessage, gmo);
            String msgText = rcvMessage.readStringOfCharLength(rcvMessage.getDataLength());
            System.out.println("The message is: " + msgText);
            MQMD md = new MQMD();
            md.copyFrom((com.ibm.mq.MQMD)rcvMessage);
            returnMsg[0] = "Receive message:\n" + md + "\n" + new MQHeaderList((DataInput)rcvMessage, true) + msgText + "\n";
            returnMsg[1] = msgText;
            System.out.println("SUCCESS");
            returnMsg[0] = returnMsg[0] + "SUCCESS\n";
            System.out.println(returnMsg[0]);
        }
        catch (IOException ex) {
            System.out.println("An IOException occured whilst writing to the message buffer: " + ex);
            ex.printStackTrace();
            throw ex;
        }
        catch (MQException ex) {
            if (this.qMgr == null || ex.getReason() != 2033) {
                // empty if block
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.mqGet");
        return returnMsg;
    }

    public String mqTopicGet(MQDestination destinationForGet, MQGetMessageOptions mgmo) throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqTopicGet");
        String returnMsg = null;
        try {
            MQMessage messageForGet = new MQMessage();
            destinationForGet.get(messageForGet, mgmo);
            String messageDataFromGet = messageForGet.readLine();
            System.out.println("Got [" + messageDataFromGet + "]");
            returnMsg = messageDataFromGet;
            System.out.println("SUCCESS");
        }
        catch (IOException ex) {
            System.out.println("An IOException occured whilst writing to the message buffer: " + ex);
        }
        catch (MQException ex) {
            if (this.qMgr == null || ex.getReason() != 2033) {
                // empty if block
            }
            throw ex;
        }
        debugMessage.printDebugMessageStdout("stop: MQBJ.mqTopicGet");
        return returnMsg;
    }

    public MQDestination mqTopicOpenforGet() throws MQException, MQDataException {
        debugMessage.printDebugMessageStdout("start: MQBJ.mqTopicOpenforGet");
        try {
            int openOptionsForGet = 8226;
            MQTopic destinationForGet = this.qMgr.accessTopic(this.topicString, this.topicObject, 1, 8226);
            debugMessage.printDebugMessageStdout("start: MQBJ.mqTopicOpenforGet");
            return destinationForGet;
        }
        catch (MQException ex) {
            if (this.qMgr != null) {
                this.qMgr.disconnect();
                this.qMgr = null;
            }
            throw ex;
        }
    }
}

