#! /bin/sh
#---------------------------------------------------------
# Clear Queues (for client connection)
#
# Arguments:
# $1 : Queue manager name
# Read <QMGR>.mqsc from current directory
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#
#---------------------------------------------------------
# return code
RET_OK=0
RET_NG=1

# source environments for performance test
. ./runpfmts.ini

#------------------------------------------------------------------
# Functions for clear all queues
#
# input:
# $TARGET_QMGR:  Queue Manager Name
# ${TARGET_QMGR}.mqsc.src:  MQSC source file
#------------------------------------------------------------------
function fnClrQueues
{
  CPH=""
  if [[ -n $SSLCIPH ]]
  then
    #printf "SSLCIPH: $SSLCIPH\n"
    CPH="-cs $SSLCIPH"
  fi

  CLB=""
  if [[ -n $CERTLABL ]]
  then
    #printf "CERTLABL: $CERTLABL\n"
    CLB="-lb $CERTLABL MQCD_VERSION_11"
  fi

  CKR=""
  # MQ for Linux 9.2.4.0 requires MQCNO_VERSION_4 when referencing
  # the environment variable MQSSLKEYR for some reason.
  # mqpcfc does not allow MQCNO_VERSION_4 to be specified as a parameter,
  # so it must be specified as an argument using -kr.
  if [[ -n $MQSSLKEYR ]]
  then
    #printf "MQSSLKEYR: $MQSSLKEYR\n"
    CKR="-kr $MQSSLKEYR"
  fi

  sourcefile=${TARGET_QMGR}.mqsc

  if [[ ! -f $sourcefile ]]
  then
    echo "Cannot find source file $sourcefile"
    return $RET_NG
  fi

  for que in `awk -F[\(\)] '$1 ~ /^[^\*]*def ql/ {print $2}' ${TARGET_QMGR}.mqsc`
  do
    mqpcfc clr -qm ${TARGET_QMGR} -q $que -x $CONNAME -ch $CHANNEL $CPH $CLB $CKR
  done

  return $RET_OK
}

#-------
# Main
#-------
USAGE="usage: $0 <Qmgr>"

if (($# == 0))
then
  echo $USAGE
  exit $RET_NG
fi

TARGET_QMGR=${1}

# Clear Queues
fnClrQueues
exit $?

