import java.util.*;
import java.io.*;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import com.ibm.wmqfte.exitroutine.api.*;

public class SampleDstStartExit implements DestinationTransferStartExit {

        public TransferExitResult onDestinationTransferStart(String sourceAgentName,
		               			            String destinationAgentName,
		       				            Map<String, String> environmentMetaData,
		       				            Map<String, String> transferMetaData, 
		       				            List<Reference<String>> fileSpecs) {
        try{
            System.out.println("DestinationTransferStartExit Start!");

            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            String vmName = bean.getName();
            long pid = Long.valueOf(vmName.split("@")[0]);
            System.out.println("VM Name : " + vmName);
            System.out.println("PID : " + pid);

            System.out.println(Thread.currentThread().getName());

            FileWriter fileWriter = new FileWriter("/tmp/MetadataD.txt");
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println("DestinationTransferStartExit Start");
            printWriter.println("SourceAgentName : " + sourceAgentName);
            printWriter.println("DestinationAgentName : " + destinationAgentName);
            printWriter.println("EnvironmentMetaData : ");
            for( String key : environmentMetaData.keySet()){
                printWriter.println(" key: " + key + ", value: " +
                    environmentMetaData.get(key));
            }
            printWriter.println("TransferMetaData : ");
            for( String key : transferMetaData.keySet()){
                printWriter.println(" key: " + key + ", value: " +
                    transferMetaData.get(key));
            }
            printWriter.println("FileList : ");
            Iterator i = fileSpecs.iterator();
            while(i.hasNext()){
                Reference sp =
                    (Reference) i.next();
                printWriter.println(sp.dereference());
            }
            printWriter.close();
            fileWriter.close();
            System.out.println("DestinationTransferStartExit Stop!");
        }catch(IOException ioe){
        }catch(Exception e){
        }
        return TransferExitResult.PROCEED_RESULT;
    }
}

