# Windows PwowerShell
#----------------------------------------------------------------------------
# Source environments for performance test
#
# Read runpfmts.bat from current directory
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#----------------------------------------------------------------------------
function fnSourceEnvironments
{
    if (Test-Path ./runpfmts.bat) {
        cmd /c "runpfmts.bat" | Select-String -Pattern '>set' |  .{process{
        if (($_ -split '>')[1].trim() -match '([^ =]+)=(.*)') {
            $ENVNAM=$matches[1]
            switch ( $ENVNAM )
            {
              RR1_SCRIPT
              {
                $env:RR1_SCRIPT=$matches[2]
                #Write-Output "set environment: RR1_SCRIPT=${env:RR1_SCRIPT}"
              }
              RR1_SCRIPT_THREAD
              {
                $env:RR1_SCRIPT_THREAD=$matches[2]
                #Write-Output "set environment: RR1_SCRIPT_THREAD=${env:RR1_SCRIPT_THREAD}"
              }
              RR2_SCRIPT
              {
                $env:RR2_SCRIPT=$matches[2]
                #Write-Output "set environment: RR2_SCRIPT=${env:RR2_SCRIPT}"
              }
              RR2_SCRIPT_THREAD
              {
                $env:RR2_SCRIPT_THREAD=$matches[2]
                #Write-Output "set environment: RR2_SCRIPT_THREAD=${env:RR2_SCRIPT_THREAD}"
              }
              RR5_SCRIPT
              {
                $env:RR5_SCRIPT=$matches[2]
                #Write-Output "set environment: RR5_SCRIPT=${env:RR5_SCRIPT}"
              }
              PL1_SCRIPT
              {
                $env:PL1_SCRIPT=$matches[2]
                #Write-Output "set environment: PL1_SCRIPT=${env:PL1_SCRIPT}"
              }
              RCV_BUFF_SIZE
              {
                $env:RCV_BUFF_SIZE=$matches[2]
                #Write-Output "set environment: RCV_BUFF_SIZE=${env:RCV_BUFF_SIZE}"
              }
              INCL_CON_TIME
              {
                $env:INCL_CON_TIME=$matches[2]
                #Write-Output "set environment: INCL_CON_TIME=${env:INCL_CON_TIME}"
              }
              CON_RETRY
              {
                $env:CON_RETRY=$matches[2]
                #Write-Output "set environment: CON_RETRY=${env:CON_RETRY}"
              }
              CON_INTERVAL
              {
                $env:CON_INTERVAL=$matches[2]
                #Write-Output "set environment: CON_INTERVAL=${env:CON_INTERVAL}"
              }
              RR1_RequestQ
              {
                $env:RR1_RequestQ=$matches[2]
                #Write-Output "set environment: RR1_RequestQ=${env:RR1_RequestQ}"
              }
              RR1_ReplyQ
              {
                $env:RR1_ReplyQ=$matches[2]
                #Write-Output "set environment: RR1_ReplyQ=${env:RR1_ReplyQ}"
              }
              RR2_RequestQ
              {
                $env:RR2_RequestQ=$matches[2]
                #Write-Output "set environment: RR2_RequestQ=${env:RR2_RequestQ}"
              }
              RR2_ReplyQ
              {
                $env:RR2_ReplyQ=$matches[2]
                #Write-Output "set environment: RR2_ReplyQ=${env:RR2_ReplyQ}"
              }
              CONNAME
              {
                $env:CONNAME=$matches[2]
                #Write-Output "set environment: CONNAME=${env:CONNAME}"
              }
              CHANNEL
              {
                $env:CHANNEL=$matches[2]
                #Write-Output "set environment: CHANNEL=${env:CHANNEL}"
              }
              RR5_RequestQPrefix
              {
                $env:RR5_RequestQPrefix=$matches[2]
                #Write-Output "set environment: RR5_RequestQPrefix=${env:RR5_RequestQPrefix}"
              }
              RR5_ReplyQPrefix
              {
                $env:RR5_ReplyQPrefix=$matches[2]
                #Write-Output "set environment: RR5_ReplyQPrefix=${env:RR5_ReplyQPrefix}"
              }
              PL1_RequestQPrefix
              {
                $env:PL1_RequestQPrefix=$matches[2]
                #Write-Output "set environment: PL1_RequestQPrefix=${env:PL1_RequestQPrefix}"
              }
              PL1_ReplyQPrefix
              {
                $env:PL1_ReplyQPrefix=$matches[2]
                #Write-Output "set environment: PL1_ReplyQPrefix=${env:PL1_ReplyQPrefix}"
              }
              MQSSLKEYR
              {
                $env:MQSSLKEYR=$matches[2]
                #Write-Output "set environment: MQSSLKEYR=${env:MQSSLKEYR}"
              }
              CERTLABL
              {
                $env:CERTLABL=$matches[2]
                #Write-Output "set environment: CERTLABL=${env:CERTLABL}"
              }
              SSLCIPH
              {
                $env:SSLCIPH=$matches[2]
                #Write-Output "set environment: SSLCIPH=${env:SSLCIPH}"
              }
              default
              {
                #Write-output "Not Supported environt: ${ENVNAM}"
              }
            }
        }
        }}
    }
}

#------------------------------------------------------
# Get Elapsed Time(9.99999999999999sec) for Thread
#
# Parameters:
# $1 : Target log name
# $2 : Number of total messages
# $3 : Number of connections
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#------------------------------------------------------
function fnGetElapsedTime_Thread
{
    param(
        [string]$logName = "",
        [int]$MESSAGES = 0,
        [int]$CONNECTIONS = 0
    )

    $FirstLine = (Get-Content -Path $logName)[0]
    $lines = (Get-Content -Path $logName).Length
    $LastLine = (Get-Content -Path $logName)[$lines - 2]
    $FirstDateTime = ($FirstLine.Remove(0,1) -split ' ')[0] + " " + ($FirstLine.Remove(0,1) -split ' ')[1]
    $LastDateTime = ($LastLine.Remove(0,1) -split ' ')[0] + " " + ($LastLine.Remove(0,1) -split ' ')[1]

    Write-Output "Start Time: $FirstDateTime Stop Time: $LastDateTime"

    $FirstDateTimeData = get-date $FirstDateTime
    $LastDateTimeData = get-date $LastDateTime

    $ElapsedTime = ($LastDateTimeData - $FirstDateTimeData)
    Write-Output "Elapsed Time: $ElapsedTime"
    
    $TOTAL_MESSAGES = ($CONNECTIONS * $MESSAGES)
    Write-Output "Total Number of messages: $TOTAL_MESSAGES"

    $RoundTrip = ($TOTAL_MESSAGES * 1000) / $ElapsedTime.TotalMilliseconds
    Write-Output "Round Trips/sec: $RoundTrip"
}

#------------------------------------------------------
# Get Elapsed Time(9.99999999999999sec)
#
# Parameters:
# $1 : Target log name prefix
# $2 : Number of total messages
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#------------------------------------------------------
function fnGetElapsedTime
{
    param(
        [string]$LOGFILE_PREFIX = "",
        [int]$MESSAGES = 0
    )

    $START_TIME_MS = 0
    $STOP_TIME_MS = 0

    $START_TIME_STR = ""
    $STOP_TIME_STR = ""

    $files = Get-Item ${LOGFILE_PREFIX}_*
    foreach($logName in $files)
    {
        $f = (Get-Content -Path $logName | select-string "^\[..../../.. ") -as [string[]]
        $FirstLine = $f[0]
        $lines = $f.Length
        $LastLine = $f[$lines - 2]
        $FirstDateTime = ($FirstLine.Remove(0,1) -split ']')[0]
        $LastDateTime = ($LastLine.Remove(0,1) -split ']')[0]

        $FirstDateTimeData = get-date $FirstDateTime
        $LastDateTimeData = get-date $LastDateTime

        if ($START_TIME_MS -eq 0)
        {
            $START_TIME_MS = $FirstDateTimeData
            $START_TIME_STR = $FirstDateTime
        }
        elseif ($START_TIME_MS -gt $FirstDateTimeData)
        {
            $START_TIME_MS = $FirstDateTimeData
            $START_TIME_STR = $FirstDateTime
        }

        if ($STOP_TIME_MS -eq 0)
        {
            $STOP_TIME_MS = $LastDateTimeData
            $STOP_TIME_STR = $LastDateTime
        }
        elseif ($STOP_TIME_MS -lt $LastDateTimeData)
        {
            $STOP_TIME_MS = $LastDateTimeData
            $STOP_TIME_STR = $LastDateTime
        }
    }

    Write-Output "Start Time: $START_TIME_STR Stop Time: $STOP_TIME_STR"

    $ElapsedTime = ($STOP_TIME_MS - $START_TIME_MS)
    Write-Output "Elapsed Time: $ElapsedTime"
    
    $TOTAL_MESSAGES = ($CONNECTIONS * $MESSAGES)
    Write-Output "Total Number of messages: $TOTAL_MESSAGES"

    $RoundTrip = ($TOTAL_MESSAGES * 1000) / $ElapsedTime.TotalMilliseconds
    Write-Output "Round Trips/sec: $RoundTrip"
}

#----------------------------------------------------------------------------
# Get the average round trips per second
#
# Parameters:
# $1 : Console log name
# $2 : Mode
#      0: Calculate average of all test shots
#      1: Calculate the average of the remaining test shots, excluding
#        the smallest and largest times (valid when the number of shots is
#        3 or more)
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#----------------------------------------------------------------------------
function fnGetAverageRoundTripsPerSec
{
    param(
        [string]$ConsoleLog = "",
        [int]$Mode = 0
    )
    
    [double]$minimum_rtps = 0
    [double]$maximum_rtps = 0
    [double]$cumulative_rtps = 0
    [int]$test_count = 0
    [double]$rtps = 0

    $ConsoleLogFile = Get-Content -Path $ConsoleLog
    #Write-Output "ConsoleLog=$ConsoleLog"
    foreach ($Line in $ConsoleLogFile) {
        if($Line -like "Round Trips*" -and $Line -ne "") {
            #Write-Output $Line
            $rtps = [double]($Line -split ' ')[2]
            if ( $minimum_rtps -eq 0 -or $minimum_rtps -gt $rtps ) {
                $minimum_rtps = $rtps
            }

            if ( $maximum_rtps -eq 0 -or $maximum_rtps -lt $rtps ) {
                $maximum_rtps = $rtps
            }
          
            $cumulative_rtps += $rtps
            $test_count += 1
        }
    }
    
    [string]$DispLine = ""
    [double]$effective_rtps = 0
    $DispLine = "${TestID}: " + "cumulative: {0:#,0.000000000000} " -f $cumulative_rtps
    #Write-Output $DispLine

    if ( $Mode -eq 1 -and $test_count -ge 3 ) {
      $effective_rtps = $cumulative_rtps - ( $minimum_rtps + $maximum_rtps )
      $test_count -= 2
      $DispLine = $DispLine + "minimum: {0:#,0.000000000000} maximum: {1:#,0.000000000000} " -f $minimum_rtps, $maximum_rtps
      #Write-Output $DispLine
    }
    else {
      $effective_rtps = $cumulative_rtps
    }
    $average_rtps = $effective_rtps / $test_count
    $DispLine = $DispLine + "average: {0:#,0.000000000000} rtps" -f $average_rtps
    Write-Output $DispLine
}
